<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no" />
    <title>UNTV - Destaques</title>
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
        href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap"
        rel="stylesheet"
    />
    <style>
        :root {
            --primary-bg: #141414;
            --overlay-color: rgba(0, 0, 0, 0.7);
            --text-color: #fff;
            --accent-color: #e50914;
            --transition-speed-bg: 1s;
            --transition-speed-content: 0.6s;
            --font-family: 'Poppins', sans-serif;
            --border-radius: 5px;
        }
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
            -webkit-tap-highlight-color: transparent;
        }
        html,
        body {
            width: 100%;
            height: 100%;
            font-family: var(--font-family);
            background: var(--primary-bg);
            overflow: hidden;
            color: var(--text-color);
            -webkit-overflow-scrolling: touch;
            touch-action: pan-y;
        }
        .banner-container {
            position: relative;
            width: 100%;
            height: 100vh;
            display: flex;
            overflow-x: scroll;
            scroll-snap-type: x mandatory;
            -webkit-overflow-scrolling: touch;
            scrollbar-width: none;
            -ms-overflow-style: none;
            will-change: scroll-position;
            -webkit-backface-visibility: hidden;
            backface-visibility: hidden;
            transform: translateZ(0);
        }
        .banner-container::-webkit-scrollbar {
            display: none;
        }
        .carousel-slide {
            flex: 0 0 100%;
            width: 100%;
            height: 100%;
            position: relative;
            scroll-snap-align: start;
            display: flex;
            justify-content: center;
            align-items: center;
            padding-bottom: 0;
            background-color: #000;
            will-change: transform, opacity;
            -webkit-backface-visibility: hidden;
            backface-visibility: hidden;
            transform: translateZ(0);
            transition: opacity var(--transition-speed-bg) ease-in-out;
        }
        .media-background {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            object-fit: cover;
            z-index: 0;
            opacity: 1;
            transition: opacity var(--transition-speed-bg) ease-in-out;
            will-change: transform;
            -webkit-backface-visibility: hidden;
            backface-visibility: hidden;
            transform: translateZ(0);
            content-visibility: auto;
        }
        .overlay {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: linear-gradient(
                to bottom,
                rgba(0,0,0,0.5) 0%,
                var(--overlay-color) 20%,
                var(--overlay-color) 80%,
                rgba(0,0,0,0.5) 100%
            );
            z-index: 2;
            will-change: opacity;
            -webkit-backface-visibility: hidden;
            backface-visibility: hidden;
            transform: translateZ(0);
        }
        .content-details {
            position: relative;
            z-index: 3;
            padding: 20px;
            text-align: center;
            opacity: 1;
            transform: translateY(0);
            transition: opacity var(--transition-speed-content) ease,
                transform var(--transition-speed-content) ease;
            will-change: transform, opacity;
            -webkit-backface-visibility: hidden;
            backface-visibility: hidden;
            transform: translateZ(0);
            max-width: 90%;
        }
        .content-details h1 {
            font-size: 4rem;
            font-weight: 700;
            margin-bottom: 0;
            text-shadow: 2px 2px 10px rgba(0, 0, 0, 0.9);
            line-height: 1.1;
        }
        .navigation-dots {
            display: none;
            visibility: hidden;
        }
        @media (max-width: 1024px) {
            .content-details {
                max-width: 90%;
            }
            .content-details h1 {
                font-size: 3rem;
            }
        }
        @media (max-width: 768px) {
            .content-details {
                max-width: 95%;
            }
            .content-details h1 {
                font-size: 2.5rem;
                margin-bottom: 0;
            }
        }
        @media (max-width: 480px) {
            .carousel-slide {
                padding-bottom: 0;
            }
            .content-details {
                max-width: 95%;
            }
            .content-details h1 {
                font-size: 1.8rem;
                margin-bottom: 0;
            }
        }
    </style>
</head>
<body>
    <div class="banner-container" id="movie-banner"></div>
    <div class="navigation-dots" id="navigation-dots"></div>

    <script>
        const apiKey = '6b8e3eaa1a03ebb45642e9531d8a76d2';
        const baseUrl = 'https://api.themoviedb.org/3/';
        const imageBaseUrl = 'https://image.tmdb.org/t/p/';
        const backdropSize = 'w780';
        const originalBackdropSize = 'original';

        const bannerContainer = document.getElementById('movie-banner');
        let carouselItems = [];
        let currentItemIndex = 0;
        let autoSlideInterval;
        const updateInterval = 8000;

        function getBackdropSize() {
            return window.innerWidth <= 768 ? backdropSize : originalBackdropSize;
        }

        async function fetchTrendingContent() {
            try {
                const [tvShowsResponse, moviesResponse, animesResponse] = await Promise.all([
                    fetch(`${baseUrl}trending/tv/week?api_key=${apiKey}&language=pt-BR`),
                    fetch(`${baseUrl}trending/movie/week?api_key=${apiKey}&language=pt-BR`),
                    fetch(`${baseUrl}discover/tv?api_key=${apiKey}&with_genres=16&language=pt-BR&sort_by=popularity.desc`)
                ]);

                const tvShowsData = await tvShowsResponse.json();
                const moviesData = await moviesResponse.json();
                const animesData = await animesResponse.json();

                const tvShows = tvShowsData.results.map(item => ({
                    id: item.id,
                    title: item.name,
                    backdrop_path: item.backdrop_path,
                }));

                const movies = moviesData.results.map(item => ({
                    id: item.id,
                    title: item.title,
                    backdrop_path: item.backdrop_path,
                }));
                
                const animes = animesData.results.map(item => ({
                    id: item.id,
                    title: item.name,
                    backdrop_path: item.backdrop_path,
                }));
                
                // Combina todas as listas e embaralha para uma apresentação mista
                let combinedItems = [...tvShows, ...movies, ...animes];
                combinedItems.sort(() => Math.random() - 0.5);

                carouselItems = combinedItems
                    .filter(item => item.backdrop_path)
                    .slice(0, 25);

                renderCarouselSlides();
                startAutoSlide();
            } catch (error) {
                console.error('Erro ao buscar conteúdo em destaque:', error);
                bannerContainer.innerHTML = `
                    <div class="carousel-slide">
                        <div class="overlay"></div>
                        <div class="content-details">
                            <h1>Ops! Não foi possível carregar o conteúdo.</h1>
                            <p>Por favor, tente novamente mais tarde.</p>
                        </div>
                    </div>
                `;
            }
        }

        function renderCarouselSlides() {
            bannerContainer.innerHTML = '';
            const size = getBackdropSize();
            carouselItems.forEach((item, index) => {
                const slide = document.createElement('div');
                slide.className = 'carousel-slide';
                slide.dataset.index = index;

                const mediaBackground = document.createElement('img');
                mediaBackground.src = `${imageBaseUrl}${size}${item.backdrop_path}`;
                mediaBackground.alt = item.title || '';
                mediaBackground.className = 'media-background';
                mediaBackground.loading = 'lazy';

                const overlay = document.createElement('div');
                overlay.className = 'overlay';

                const contentDetails = document.createElement('div');
                contentDetails.className = 'content-details';

                const titleElement = document.createElement('h1');
                titleElement.textContent = item.title || 'Título Desconhecido';

                contentDetails.appendChild(titleElement);

                slide.appendChild(mediaBackground);
                slide.appendChild(overlay);
                slide.appendChild(contentDetails);

                bannerContainer.appendChild(slide);
            });
        }

        function scrollToCurrentSlide() {
            const slideWidth = bannerContainer.clientWidth;
            bannerContainer.scrollTo({
                left: currentItemIndex * slideWidth,
                behavior: 'smooth',
            });
        }

        function startAutoSlide() {
            autoSlideInterval = setInterval(() => {
                currentItemIndex = (currentItemIndex + 1) % carouselItems.length;
                scrollToCurrentSlide();
            }, updateInterval);
        }

        bannerContainer.addEventListener('scroll', () => {
            const scrollLeft = bannerContainer.scrollLeft;
            const slideWidth = bannerContainer.clientWidth;
            const closestIndex = Math.round(scrollLeft / slideWidth);

            if (closestIndex !== currentItemIndex) {
                currentItemIndex = closestIndex;
            }
        });

        window.addEventListener('resize', () => {
            setTimeout(() => {
                renderCarouselSlides();
                scrollToCurrentSlide();
            }, 200);
        });

        fetchTrendingContent();
    </script>
</body>
</html>